﻿IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[SP_Stk_Depositos]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].SP_Stk_Depositos 
END
GO

CREATE PROCEDURE [dbo].[SP_Stk_Depositos]

AS
SET NOCOUNT ON

/*Declaracion Variables Locales*/

DECLARE @Mensaje			VARCHAR(100)
		,@UltError			INT
		,@Id_Trans			INT
		,@ID_PRODUCTO		VARCHAR(14)
		,@Importe			DECIMAL(16,2)
		,@Email_Cob			VARCHAR(256)
		,@Id_Trans_Rec		INT
		,@CursorOpen        INT
		,@Flag_Cbte_Tipo	SMALLINT
		,@Periodo           DATE 
		,@Id_sucursal	    SMALLINT
		,@Existe      	    SMALLINT
		,@DepFisico         CHAR(3)
		,@DepLogico         CHAR(3)
		,@Cantidad			DECIMAL(16,0)

  SELECT ID_PRODUCTO INTO #STOCK FROM PRODUCTOS WHERE 1=0
		
  ALTER Table #STOCK  ADD
				DESCRIPCION	   	VARCHAR(150),
				LISTA1          DECIMAL(16,2),
			    LISTA6   	   	DECIMAL(16,2),
				COSTO   	   	DECIMAL(16,2),
				COSTOS_REAL     DECIMAL(16,2),
				STK_OC	   	    INT,	
				STK_1   	   	INT,
				STK_2   	   	INT,	
				STK_3   	   	INT,	
				STK_4   	   	INT,
		    	STK_5   	   	INT,
			   	STK_6   	   	INT,
			   	STK_7   	   	INT,
			   	STK_8   	   	INT,
			   	STK_9   	   	INT,
				STK_FULLFI   	INT,
				STK_VIRTUAL   	INT,
			 	STK_SRV   	   	INT,
			 	STK_SRV_EXT	   	INT,
				TOTAL    	   	INT,
				FAMILIA_ID      INT,
				DESC_FAM VARCHAR(35)      						
								 						
BEGIN 


    INSERT INTO #STOCK
    SELECT P.ID_PRODUCTO AS ID_PRODUCTO ,P.DESCRIPCION_DETALLADA AS DESCRIPCION ,L1.PRECIO AS LISTA1,L6.PRECIO AS LISTA6,P.COSTO AS COSTO ,P.COSTO_COMPARATIVO AS COSTO_REAL,
		    0 AS    STK_OC,
		    0 AS    STK_1,
			0 AS	STK_2,
			0 AS	STK_3,
			0 AS	STK_4,
		    0 AS 	STK_5,
			0 AS   	STK_6 ,
			0 AS   	STK_7 ,
			0 AS   	STK_8 ,
			0 AS   	STK_9 ,
			0 AS	STK_FULLFI,
			0 AS	STK_VIRTUAL,
			0 AS 	STK_SRV ,
			0 AS 	STK_SRV_EXT,
			0 AS	TOTAL,
			P.Id_Familia  AS  ID_FAMILIA,
			F.DESCRIPCION  AS  DESC_FAM
       FROM Productos P,Prod_Listas_Precios_Items L1, Prod_Listas_Precios_Items L6, Prod_Familias F
	   WHERE P.Activo = 1
	   AND P.Vendible = 1
	   AND P.Maneja_Stock = 1
	   AND P.ID_FAMILIA = F.ID_FAMILIA
	   AND P.ID_PRODUCTO = L1.ID_PRODUCTO
	   AND P.ID_PRODUCTO = L6.ID_PRODUCTO
	   AND L1.Id_Lista_Precio = 1
	   AND L6.Id_Lista_Precio = 6


   DECLARE TagCbtesCursor CURSOR FOR  

       select I.ID_PRODUCTO,C.Id_Dep_Fisico,C.Id_Dep_Logico,sum(i.Cantidad*isnull(t.compromete_Stock,1)) AS CANTIDAD
		   from cbtes c, cbtes_tipos t, cbtes_items i, #STOCK S
		   where c.id_tipo_cbte  = t.id_tipo_cbte
		   and I.Id_Trans = c.Id_Trans
		   And c.id_Estado_Cbte <> 3
		   and I.id_Producto = S.Id_Producto 
		   And t.compromete_Stock in (1,-1)
		   group by I.ID_PRODUCTO,C.Id_Dep_Fisico,C.Id_Dep_Logico 

	OPEN TagCbtesCursor

	FETCH NEXT FROM TagCbtesCursor INTO @ID_PRODUCTO,@DepFisico,@DepLogico,@Cantidad
	SET @CursorOpen = 0	
	SET @UltError = 0
	WHILE @@FETCH_STATUS=0 AND @UltError  = 0
	BEGIN
	       IF @DepFisico = '1' AND @DepLogico = '1'   Update #STOCK SET STK_1 = STK_1 + @Cantidad WHERE ID_PRODUCTO =  @ID_PRODUCTO 
	       IF @DepFisico = '2' AND @DepLogico = '2'   Update #STOCK SET STK_2 = STK_2 + @Cantidad WHERE ID_PRODUCTO =  @ID_PRODUCTO 
	       IF @DepFisico = '3' AND @DepLogico = '3'   Update #STOCK SET STK_3 = STK_3 + @Cantidad WHERE ID_PRODUCTO =  @ID_PRODUCTO 
	       IF @DepFisico = '4' AND @DepLogico = '4'   Update #STOCK SET STK_4 = STK_4 + @Cantidad WHERE ID_PRODUCTO =  @ID_PRODUCTO 
	       IF @DepFisico = '5' AND @DepLogico = '5'   Update #STOCK SET STK_5 = STK_5 + @Cantidad WHERE ID_PRODUCTO =  @ID_PRODUCTO 
	       IF @DepFisico = '6' AND @DepLogico = '6'   Update #STOCK SET STK_6 = STK_6 + @Cantidad WHERE ID_PRODUCTO =  @ID_PRODUCTO
	       IF @DepFisico = '7' AND @DepLogico = '7'   Update #STOCK SET STK_7 = STK_7 + @Cantidad WHERE ID_PRODUCTO =  @ID_PRODUCTO 
	       IF @DepFisico = '8' AND @DepLogico = '8'   Update #STOCK SET STK_8 = STK_8 + @Cantidad WHERE ID_PRODUCTO =  @ID_PRODUCTO 
	       IF @DepFisico = '9' AND @DepLogico = '9'   Update #STOCK SET STK_9 = STK_9 + @Cantidad WHERE ID_PRODUCTO =  @ID_PRODUCTO 
	       IF @DepFisico = '15' AND @DepLogico = '15'   Update #STOCK SET STK_9 = STK_9 + @Cantidad WHERE ID_PRODUCTO =  @ID_PRODUCTO 
	       IF @DepFisico = '19' AND @DepLogico = '19'   Update #STOCK SET STK_5 = STK_5 + @Cantidad WHERE ID_PRODUCTO =  @ID_PRODUCTO 
	       IF @DepFisico = '22' AND @DepLogico = '22'   Update #STOCK SET STK_3 = STK_3 + @Cantidad WHERE ID_PRODUCTO =  @ID_PRODUCTO 
	       IF @DepFisico = '26' AND @DepLogico = '26'   Update #STOCK SET STK_6 = STK_6 + @Cantidad WHERE ID_PRODUCTO =  @ID_PRODUCTO 


   		FETCH NEXT FROM TagCbtesCursor INTO @ID_PRODUCTO,@DepFisico,@DepLogico,@Cantidad

	END
	CLOSE TagCbtesCursor
	DEALLOCATE TagCbtesCursor

--		/*FIN */
		

END 

  SELECT * FROM #STOCK 

  DROP TABLE #STOCK


 /* 

 exec SP_Stk_Depositos
 

 FIN */