IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.SF_BancoPayPerTIC_TX') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.SF_BancoPayPerTIC_TX
END
GO

IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_BancoPayPerTIC_TX') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_BancoPayPerTIC_TX
END
GO

CREATE FUNCTION [dbo].[CF_BancoPayPerTIC_TX](@pId_Trans INT, @pImporte DECIMAL(12,2), @pId_Tar_Lote INT) 
RETURNS VARCHAR(500)
AS
BEGIN

/*Variable de Retorno*/
DECLARE @Retorno			VARCHAR(500)
/*FIN Variable de Retorno*/

/*Variables del Archivo*/
DECLARE @aSeparador				CHAR(1)
DECLARE @aId_Trans				VARCHAR(10)		/*Identificador interno de transaccin para la entidad recaudadora*/
DECLARE @aId_Cliente			VARCHAR(10)		/*Identificador unvoco del pagador*/
DECLARE @aRazon_Social			VARCHAR(100)	/*Nombre del pagador*/
DECLARE @aTelefono				VARCHAR(900)	/*Telfono del pagador (SOLO numeros)*/
DECLARE @aEmail					VARCHAR(8000)	/*E-mail del pagador*/
DECLARE @aId_Producto			VARCHAR(14)		/*Identificador del concepto a cobrar*/
DECLARE @aDescripcion_Prod		VARCHAR(100)	/*Descripcin del concepto a cobrar*/
DECLARE @aImp_Total				VARCHAR(10)		/*Monto a cobrar (Solo numeros con punto decimal)*/
DECLARE @aRecurrenciaCobro		VARCHAR(2)		/*Recurrencia del cobro. *Modalidad Debito Automatico: Valor '0': El cobro se repetir cada mes, todos los meses. Valor !=0: El cobro se repetir tantas veces como este valor indique.   *Modalidad e-Commerce: El valor indica la cantidad de cuotas a realizar.*/
DECLARE @aURLCambios			VARCHAR(255)	/*URL a la cual se enviaran las notificaciones con el cambio de estado de los pagos.*/
DECLARE @aFechaVencimiento		VARCHAR(19)		/*Fecha de vencimiento.  Es la fecha del da por defecto.  No es tomado en cuenta para pagos online (dd/mm/aaaa hh:mm:ss)*/
DECLARE @aUltFechaPago			VARCHAR(19)		/* ltima fecha para aceptar el pago, durante este perodo se aplica el rate y el charge. Por defecto es el da 24 del mes en curso. No es tomado en cuenta para pagos online (dd/mm/aaaa hh:mm:ss)*/
DECLARE @aTNAACobrar			VARCHAR(3)		/*TNA tasa de inters anual a cobrar entre los vencimientos. Por defecto es 0. No es tomado en cuenta para pagos online*/
DECLARE @aImpFijoDiferimiento	VARCHAR(10)		/*Importe fijo a aplicar en el diferimiento*/
DECLARE @aImpMinAAplicarVenc	VARCHAR(10)		/*Importe MNIMO  a aplicar en el vencimiento*/
DECLARE @aTipoMedioPago			VARCHAR(5)		/*Tipo de medio de pago*/
DECLARE @aNroMedioPago			VARCHAR(22)		/*Nmero de medio de pago. CBU: 22 dgitos VISA: 16 dgitos MASTER: 16 dgitos AMEX: 15 dgitos No es tomado en cuenta para pagos online.*/
DECLARE @aNroPromo				VARCHAR(10)		/* Numero de promocin el cual se obtiene del servicio de promociones. Nota: Este campo solo es valido para transacciones online y depende de la entidad con la cual se procese*/
DECLARE @aPriDatoAdicCli		VARCHAR(100)	/*Primer dato adicional del cliente*/
DECLARE @aSegDatoAdicCli		VARCHAR(100)	/*Segundo dato adicional del cliente*/
DECLARE @aId_Moneda				VARCHAR(3)		/*Identficador de la moneda de la transaccin (ARS, USD, etc)*/
DECLARE @aURLFinalizarPagoOnline VARCHAR(255)	/*URL a la cual se redireccionar luego de finalizar la transaccin - slo para pago online*/
DECLARE @aURLFinalizarPago 		VARCHAR(255)	/*URL a la cual podra regresar el pagador luego de la transaccin*/
DECLARE @aURLNotificacionesPago	VARCHAR(255)	/*URL a la cual se enviaran las notificaciones con el cambio de estado de los pagos*/
DECLARE @SesionGenerada			VARCHAR(500)	/*Sesin generada por el servicio de autentificacin. Este campo solo se requiere si en la configuracin del comercio lo especifica.*/
DECLARE @PermControlIntegMsg	VARCHAR(500)	/*Permite controlar la integridad del mensaje enviado por el cliente.*/
DECLARE @Formato				CHAR(1)			/*A: API v1 / B: API v2*/
DECLARE @aPais_Expide_Identificacion	CHAR(3)/*Pais que expide la identificacion (String)*/
DECLARE @aTipoIdentificacion_Socio		CHAR(7)/*Tipo de identificacin (String)*/
DECLARE @aNumeroIdentificacion_Socio	CHAR(14)/*Nmero de identificacin (String)*/
/*FIN Variables del Archivo*/

/*Variables Intermedias*/
DECLARE @Id_Cliente				INT
DECLARE @Id_Cliente_Externo		VARCHAR(14)
DECLARE @Razon_Social			VARCHAR(100)
DECLARE @Telefono				VARCHAR(900)
DECLARE @Email					VARCHAR(8000)
DECLARE @Id_Producto			VARCHAR(14)
DECLARE @Descripcion_Prod		VARCHAR(100)
DECLARE @Fecha_QA				DATETIME
DECLARE @Fecha_Presentacion		DATETIME
DECLARE @Fecha_Venc				DATETIME
DECLARE @Fecha_Venc_VC			VARCHAR(20)
DECLARE @Fecha_Ult_Pago			DATETIME
DECLARE @Fecha_Ult_Pago_VC		VARCHAR(20)
DECLARE @Doc_Nro				BIGINT
/*FIN Variables Intermedias*/

/*Calculos intermerdios*/
SET @Formato			= (dbo.CF_xParam('PayPerTic_Formato'))

SET @Fecha_Presentacion	= (SELECT ISNULL(Fecha, GETDATE()) FROM Val_Tarjetas_Lotes WHERE Id_Tar_Lote = @pId_Tar_Lote)
SET @Fecha_Presentacion	= CONVERT(DATE, @Fecha_Presentacion)

SELECT  @Id_Cliente		= ISNULL(Id_Cliente, 0),
		@Fecha_Venc		= ISNULL(Fecha_Venc, DATEADD(dd, 10, Fecha))
FROM Cbtes
WHERE 
Id_Trans = @pId_Trans

SET @Fecha_Venc		= DATEADD(dd, 10, @Fecha_Presentacion)	--Los clubes mandan a PayPerTic la deuda Historica, por lo tanto la fecha de Venc no sirve, ya que el webService espera de la fecha actual 10 dias mas.

SET @Fecha_Venc_VC =	RIGHT('00' + CAST(DAY(@Fecha_Venc) AS VARCHAR),2) +
						'/' +
						RIGHT('00' + CAST(MONTH(@Fecha_Venc) AS VARCHAR),2) + 
						'/' +
						CAST(DATEPART(YY, @Fecha_Venc) AS CHAR(4)) + 
						' ' +
						RIGHT('00' + CAST(DATEPART(HH, @Fecha_Venc) AS VARCHAR),2) +
						':' +
						RIGHT('00' + CAST(DATEPART(MINUTE, @Fecha_Venc) AS VARCHAR),2) +
						':' +
						RIGHT('00' + CAST(DATEPART(SECOND, @Fecha_Venc) AS VARCHAR),2)

SET @Fecha_Ult_Pago = DATEADD(dd, 10, @Fecha_Venc)

SET @Fecha_Ult_Pago_VC = RIGHT('00' + CAST(DAY(@Fecha_Ult_Pago) AS VARCHAR),2) +
						'/' +
						RIGHT('00' + CAST(MONTH(@Fecha_Ult_Pago) AS VARCHAR),2) + 
						'/' +
						CAST(DATEPART(YY, @Fecha_Ult_Pago) AS CHAR(4)) + 
						' ' +
						RIGHT('00' + CAST(DATEPART(HH, @Fecha_Ult_Pago) AS VARCHAR),2) +
						':' +
						RIGHT('00' + CAST(DATEPART(MINUTE, @Fecha_Ult_Pago) AS VARCHAR),2) +
						':' +
						RIGHT('00' + CAST(DATEPART(SECOND, @Fecha_Ult_Pago) AS VARCHAR),2)

/*=============================================================================*/

SELECT  @Id_Cliente_Externo = ISNULL(LTRIM(RTRIM(Id_Cliente_Externo)), CONVERT(VARCHAR(14), Id_Cliente)),
		@Razon_Social		= ISNULL(LTRIM(RTRIM(Razon_Social)), LTRIM(RTRIM(Apellido)) + ' ' + LTRIM(RTRIM(Nombre))),
		@Telefono			= ISNULL(LTRIM(RTRIM(Telefono)), ''),
		@Email				= ISNULL(LTRIM(RTRIM(CONVERT(VARCHAR(8000), Email))), ''),
		@Doc_Nro			= ISNULL(Doc_Nro, 0)
FROM Clientes
WHERE 
Id_Cliente = @Id_Cliente

SET @Razon_Social = REPLACE(@Razon_Social, ',', '') --Hay que sacar las comas porque sino lo toma como separador de campo

SET @Telefono = REPLACE(@Telefono, '-', '')
SET @Telefono = REPLACE(@Telefono, '(', '')
SET @Telefono = REPLACE(@Telefono, ')', '')

IF(ISNUMERIC(@Telefono) = 0)
BEGIN
	SET @Telefono = ''
END

/*=============================================================================*/

SELECT	TOP 1 
		@Id_Producto		= LTRIM(RTRIM(Id_Producto)),  
		@Descripcion_Prod	= LTRIM(RTRIM(Descripcion_producto)), 
		@Fecha_QA			= Fecha_QA
FROM Cbtes_Items 
WHERE 
Id_Trans = @pId_Trans 
ORDER BY Imp_Final DESC
/*FIN Calculos intermerdios*/

/*Grabacion de los campos de la fila*/
SET @aSeparador				= ','

SET @aId_Trans				= @pId_Trans
SET @aId_Cliente			= @Id_Cliente_Externo --Segn conversacin via Skype 18/07/2018 con Kevin Forgalan (kevpf_1) ejecutivo de Cuenta de PayPerTic este Numero es con el que los socios van a pagar
SET @aRazon_Social			= @Razon_Social
SET @aTelefono				= '' --@Telefono Segn conversacin via Skype 18/07/2018 con Kevin Forgalan (kevpf_1) ejecutivo de Cuenta de PayPerTic si este dato no esta perfectamente parseado como telefono es mejo enviarlo vacio
SET @aEmail					= @Email
SET @aId_Producto			= @Id_Producto
SET @aDescripcion_Prod		= CAST(DATEPART(YY, @Fecha_QA) AS CHAR(4)) + '/' + RIGHT('00' + CAST(MONTH(@Fecha_QA) AS VARCHAR),2) + ' ' + @Descripcion_Prod
SET @aImp_Total				= CONVERT(VARCHAR(10), @pImporte)
/*Para futuras implementaciones*/
SET @aRecurrenciaCobro		= ''
SET @aURLCambios			= '' --Este campo cuando se tenga una API se pueden recibir novedades
SET @aFechaVencimiento		= @Fecha_Venc_VC
SET @aUltFechaPago			= @Fecha_Ult_Pago_VC
SET @aTNAACobrar			= ''
SET @aImpFijoDiferimiento	= ''
SET @aImpMinAAplicarVenc	= ''
SET @aTipoMedioPago			= ''
SET @aNroMedioPago			= ''
SET @aNroPromo				= ''
SET @aPriDatoAdicCli		= ''
SET @aSegDatoAdicCli		= ''
SET @aId_Moneda				= 'ARS' /*Pesos Argentinos*/
SET @aURLFinalizarPagoOnline= ''
SET @aURLFinalizarPago		= ''
SET @aURLNotificacionesPago = ''
SET @SesionGenerada			= ''
SET @PermControlIntegMsg	= ''
SET @aPais_Expide_Identificacion= 'ARG'
SET @aTipoIdentificacion_Socio	= 'DNI_ARG'
SET @aNumeroIdentificacion_Socio= CONVERT(VARCHAR(20), @Doc_Nro)
/*FIN Grabacion de los campos de la fila*/

/*Grabacin de la Fila Completa*/

IF(@Formato = 'A') /*API version 1*/
BEGIN
	SET @Retorno			=	@aId_Trans				+ @aSeparador +
								@aId_Cliente			+ @aSeparador +
								@aRazon_Social			+ @aSeparador +
								@aTelefono				+ @aSeparador +
								@aEmail					+ @aSeparador +
								@aId_Producto			+ @aSeparador +
								@aDescripcion_Prod		+ @aSeparador +
								@aImp_Total				+ @aSeparador +
								@aRecurrenciaCobro		+ @aSeparador +
								@aURLCambios			+ @aSeparador +
								@aFechaVencimiento		+ @aSeparador +
								@aUltFechaPago			/*+ @aSeparador +
								@aTNAACobrar			+ @aSeparador +
								@aImpFijoDiferimiento	+ @aSeparador +
								@aImpMinAAplicarVenc	+ @aSeparador +
								@aTipoMedioPago			+ @aSeparador +
								@aNroMedioPago			+ @aSeparador +
								@aNroPromo				+ @aSeparador +
								@aPriDatoAdicCli		+ @aSeparador +
								@aSegDatoAdicCli		+ @aSeparador +
								@SesionGenerada			+ @aSeparador +
								@PermControlIntegMsg*/
END

IF(@Formato = 'B') /*API version 2*/
BEGIN
	/*
	--Hasta el 06/10/2020. Modificada por Reunin con Buchardo y responsable de PayPerTic Martin
	SET @Retorno			=	@aId_Trans				+ @aSeparador +
								@aId_Trans				+ @aSeparador +
								@aId_Producto			+ @aSeparador +
								@aDescripcion_Prod		+ @aSeparador +
								@aId_Moneda				+ @aSeparador +
								@aImp_Total				+ @aSeparador +
								@aFechaVencimiento		+ @aSeparador +
								@aUltFechaPago			+ @aSeparador +
								@aURLFinalizarPagoOnline+ @aSeparador +
								@aURLFinalizarPago		+ @aSeparador +
								@aURLNotificacionesPago + @aSeparador +
								@aTNAACobrar			+ @aSeparador +
								@aImpFijoDiferimiento	+ @aSeparador +
								@aNroMedioPago			+ @aSeparador +
								@aNroPromo				+ @aSeparador +
								@aPriDatoAdicCli		+ @aSeparador +							
								@aId_Cliente			+ @aSeparador +
								@aRazon_Social												
	*/
	SET @Retorno			=	@aId_Trans						+ @aSeparador +					/*Identificador UNICO para cada transaccion informada (String)*/
								@aId_Trans						+ @aSeparador +					/*Identificador interno de transaccin para la entidad recaudadora (String)*/
								@aId_Producto					+ @aSeparador +					/*Identificador del concepto a cobrar (String)*/
								@aDescripcion_Prod				+ @aSeparador +					/*Descripcin del concepto a cobrar (String)*/
								@aId_Moneda						+ @aSeparador +					/*Identficador de la moneda de la transaccin (ARS, USD, etc)*/
								@aImp_Total						+ @aSeparador +					/*Monto a cobrar (Double - Solo numeros con punto decimal)*/
								@aFechaVencimiento				+ @aSeparador +					/*Fecha de vencimiento. Es la fecha del da por defecto. No es tomado en cuenta para pagos online (dd/mm/aaaa hh:mm:ss)*/
								@aUltFechaPago					+ @aSeparador +					/*ltima fecha para aceptar el pago, durante este perodo se aplica el rate y el charge. Por defecto es el da 24 del mes en curso. No es tomado en cuenta para pagos online (dd/mm/aaaa hh:mm:ss)*/
								@aURLFinalizarPagoOnline		+ @aSeparador +					/*URL a la cual se redireccionar luego de finalizar la transaccin - slo para pago online. (String)*/
								@aURLFinalizarPago				+ @aSeparador +					/*URL a la cual podra regresar el pagador luego de la transaccin. (String)*/
								@aURLNotificacionesPago			+ @aSeparador +					/*URL a la cual se enviaran las notificaciones con el cambio de estado de los pagos. (String)*/
								@aTNAACobrar					+ @aSeparador +					/*TNA tasa de inters anual a cobrar entre los vencimientos. Por defecto es 0.*/
								@aImpFijoDiferimiento			+ @aSeparador +					/*Importe fijo a aplicar en el diferimiento (Double)*/
								@aNroMedioPago					+ @aSeparador +					/*Nmero de medio de pago. CBU: 22 dgitos VISA: 16 dgitos MASTER: 16 dgitos AMEX: 15 dgitos No es tomado en cuenta para pagos online.*/
								@aNroPromo						+ @aSeparador +					/*Numero de promocin el cual se obtiene del servicio de promociones. Nota: Este campo solo es valido para transacciones online y depende de la entidad con la cual se procese (String)*/
								@aPriDatoAdicCli				+ @aSeparador +					/*Cualquier tipo de informacion adicional*/
								@aId_Cliente					+ @aSeparador +					/*Identificador del pagador*/
								@aRazon_Social					+ @aSeparador +					/*Nombre del pagador (String)*/
								@aEmail							+ @aSeparador +					/*Email del pagador (String)*/
								@aTelefono						+ @aSeparador +					/*Telefono del pagador (String)*/
								@aPais_Expide_Identificacion	+ @aSeparador +					/*Pais que expide la identificacion (String)*/
								@aTipoIdentificacion_Socio		+ @aSeparador +					/*Tipo de identificacin (String)*/
								@aNumeroIdentificacion_Socio									/*Nmero de identificacin (String)*/											
END
/*FIN Grabacion de la Fila Completa*/

RETURN @retorno
END
