IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Producto_Validar') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Producto_Validar
END
GO



CREATE FUNCTION [dbo].[CF_Producto_Validar](@pId_Cliente INT, @pId_Producto VARCHAR(50))
RETURNS INT
AS
BEGIN

DECLARE @Respuesta				INT
DECLARE @Fecha_Venc             DATETIME

	DECLARE cur_Valida_Turno CURSOR FOR
		select @pId_Cliente,@pId_Producto

		OPEN cur_Valida_Turno
		FETCH NEXT FROM cur_Valida_Turno INTO @pId_Cliente,@pId_Producto
		WHILE @@FETCH_STATUS = 0
		BEGIN

		SET @Fecha_Venc=( SELECT top 1 ISNULL(DATEADD(DAY,PCV.Cant_Dias_Gracia,CV.Fecha),'19900101') FROM  
						Clientes_Venc CV,	Prod_Cli_Venc PCV
						WHERE 
						 CV.Id_Tipo_Venc= PCV.Id_Tipo_Venc
						AND Id_Producto=@pId_Producto AND id_cliente=@pId_Cliente)

			IF (@Fecha_Venc< GETDATE())
			BEGIN
			SET @Respuesta = 0
			BREAK
			END
			ELSE
			BEGIN
			SET @Respuesta = 1
			END

		FETCH NEXT FROM cur_Valida_Turno INTO   @pId_Cliente,@pId_Producto
		END
		CLOSE cur_Valida_Turno
		DEALLOCATE cur_Valida_Turno
	
RETURN @Respuesta
END