IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_Turno_Cli_Agregar]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CP_Turno_Cli_Agregar] 
END
GO
CREATE PROCEDURE [dbo].[CP_Turno_Cli_Agregar] (
	@Id_Turno					INT,
	@Id_Cliente					INT
	) 

AS
 
DECLARE @Mensaje				VARCHAR(100)
DECLARE @Cupo_Max_Comp_Tipo		CHAR(1)		-- Tipo de reserva
DECLARE @Id_Turno_Acomp			INT			-- 
DECLARE @Id_Recurso_Horario		INT
DECLARE @Fecha					DATETIME

BEGIN TRY
BEGIN TRAN

	SELECT
		@Id_Recurso_Horario= Id_Recurso_Horario, 
		@Fecha= Fecha
		FROM CRM_Turnos
		WHERE Id_Turno=@Id_Turno

	SET  @Cupo_Max_Comp_Tipo = ISNULL((SELECT Cupo_Max_Comp_Tipo FROM Empresas_Sedes_Sec_Recuros_Horarios 
									WHERE Id_Recurso_Horario=@Id_Recurso_Horario),'A')

	IF(@Cupo_Max_Comp_Tipo <>'A')
	BEGIN
		INSERT INTO CRM_Turnos_Clientes(Id_Turno, Id_Cliente) VALUES(@Id_Turno,@Id_Cliente)
	END

	ELSE
	BEGIN

		SET  @Id_Turno_Acomp = ISNULL((SELECT MIN(Id_Turno) FROM CRM_Turnos 
		WHERE Id_Recurso_Horario=@Id_Recurso_Horario and Fecha=@Fecha AND Estado<>'R'),0)

		IF (@Id_Turno_Acomp <>0)
			UPDATE CRM_Turnos SET Id_Cliente=@Id_Cliente, Estado='R', Tipo_Reserva ='A',	Fecha_Asignacion = GETDATE()	
			WHERE Id_Turno=@Id_Turno_Acomp

		INSERT INTO CRM_Turnos_Clientes(Id_Turno, Id_Cliente, Id_Turno_Tomado) 
		VALUES(@Id_Turno,@Id_Cliente,@Id_Turno_Acomp)

	END

	COMMIT
	SELECT	 0					AS ErrorNumber 
			,0					AS ErrorSeverity  
			,0					AS ErrorState 
			,0					AS ErrorProcedure  
			,0					AS ErrorLine		
			,@Mensaje			AS ErrorMessage

END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo;  
	ROLLBACK
END CATCH;   
