IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Prisma_MasterCard_Cred_TX') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Prisma_MasterCard_Cred_TX
END
GO



CREATE FUNCTION [dbo].[CF_Prisma_MasterCard_Cred_TX](@pId_Trans INT, @pImporte DECIMAL(12,2), @pId_Tar_Lote INT)
RETURNS CHAR(100)
AS
BEGIN

/*Variable de Retorno*/
DECLARE @Retorno			CHAR(100)
/*FIN Variable de Retorno*/


IF EXISTS ( SELECT * FROM sysobjects 
			WHERE 
			id = object_id(N'dbo.CF_Prisma_MasterCard_Cred_TX_') 
			AND type = 'FN')
BEGIN
	/*Si existe la funcin personalizada CF_Turno_Validar_ utiliza esa*/
    SET @Retorno = (dbo.CF_Prisma_MasterCard_Cred_TX_(@pId_Trans , @pImporte , @pId_Tar_Lote ))
    RETURN ISNULL(@Retorno, '')
END




/*Variables del Archivo*/
DECLARE @aTipoRegistro		CHAR(1)	/*LONG: 01. INI: 01. FIN: 01. Tipo de Registro. Fijo "1"*/
DECLARE @aNumeroTarjeta		CHAR(16)/*LONG: 16. INI: 02. FIN: 17. Numero de Tarjeta*/
DECLARE @aReservado01		CHAR(3)	/*LONG: 03. INI: 18. FIN: 20. Reservado. Constante espacios*/
DECLARE @aNroReferencia		CHAR(8)	/*LONG: 08. INI: 21. FIN: 28. Referencia o numero de comprobante o Nro. Secuencial ascendente unico por archivo.*/
DECLARE @aFechaOrigenVencDeb CHAR(8)/*LONG: 08. INI: 29. FIN: 36. Fecha de origen o vencimiento del debito. Formato AAAAMMDD*/
DECLARE @aCodigoTransaccion	CHAR(4)	/*LONG: 04. INI: 37. FIN: 40. Codigo de Transaccion. Fijo "0005"*/
DECLARE @aImporte			CHAR(15)/*LONG: 15. INI: 41. FIN: 55. Importe*/
DECLARE @aIdentificadorDeb	CHAR(15)/*LONG: 15. INI: 56. FIN: 70. Identificador del Debito*/
DECLARE @aCodigoAltaIdent	CHAR(1)	/*LONG: 01. INI: 71. FIN: 71. Codigo de alta del Identificador. Constante E si es el primer debito informado, sino espacios*/
DECLARE @aEstadoRegistro	CHAR(2)	/*LONG: 02. INI: 72. FIN: 73. Estado del registro - Fijo: " "*/
DECLARE @aReservado02		CHAR(26)/*LONG: 26. INI: 74. FIN: 99. Reservado. Constante espacios*/
DECLARE @aMarcaFin			CHAR(1)	/*LONG: 01. INI: 100. FIN: 100. Marca de fin de registro. Fijo "*"*/
/*FIN Variables del Archivo*/


/*Variables Intermedias*/
DECLARE @Tar_Nro				VARCHAR(22)
DECLARE @Fecha_Venc				DATETIME
DECLARE @Id_Cliente				INT
/*FIN Variables Intermedias*/

/*=================================================================================*/

SELECT	@Tar_Nro		= LTRIM(RTRIM(ISNULL(Nro, '')))
FROM Val_Tarjetas_Lotes_Items 
WHERE
Id_Tar_Lote = @pId_Tar_Lote
AND Id_Trans = @pId_Trans

SELECT	@Fecha_Venc		= ISNULL(Fecha_Venc, '19000101'),
		@Id_Cliente		= ISNULL(Id_Cliente, 0)
FROM Cbtes 
WHERE
Id_Trans = @pId_Trans


/*=================================================================================*/

SET @aTipoRegistro		= '1'

SET @aNumeroTarjeta		= (RIGHT('0000000000000000' + CAST(@Tar_Nro AS VARCHAR), 16))

SET @aReservado01		= '   '

SET @aNroReferencia		= (RIGHT('00000000' + CAST(@pId_Trans AS VARCHAR), 8))

SET @aFechaOrigenVencDeb = SUBSTRING(CAST(DATEPART(YY, @Fecha_Venc) AS CHAR(4)),3,2) + RIGHT('00' + CAST(MONTH(@Fecha_Venc) AS VARCHAR),2) + RIGHT('00' + CAST(DAY(@Fecha_Venc) AS VARCHAR),2)

SET @aCodigoTransaccion = '0005'

SET @aImporte			= RIGHT('000000000000000' + CAST(CAST(@pImporte * 100 AS INT) AS VARCHAR), 15)

SET @aIdentificadorDeb	= RIGHT('000000000000000' + CAST(@Id_Cliente AS VARCHAR), 15)

SET @aCodigoAltaIdent	= 'E'

SET @aEstadoRegistro	= '  '

SET @aReservado02		= '                          '

SET @aMarcaFin			= '*'

/*=================================================================================*/

SET @retorno =	@aTipoRegistro		+
				@aNumeroTarjeta		+
				@aReservado01		+
				@aNroReferencia		+
				@aFechaOrigenVencDeb +
				@aCodigoTransaccion	+
				@aImporte			+
				@aIdentificadorDeb	+
				@aCodigoAltaIdent	+
				@aEstadoRegistro	+
				@aReservado02		+
				@aMarcaFin			

RETURN @retorno
END
